<?php
$lng = $this->session->userdata('language');
$ln_text = isset($lng) && $lng && $lng=="bangla"?"bangla":'';
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo lang('purchase_no'); ?>:<?=($ln_text=="bangla"?banglaNumber($expense->reference_no):$expense->reference_no)?></title>
    <link rel="stylesheet" href="<?php echo base_url(); ?>assets/plugins/local/google_font.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>frequent_changing/css/print_invoice_a4.css">
    <link rel="stylesheet" href="<?php echo base_url(); ?>frequent_changing/css/inv_common.css">
</head>
<body>
    <div id="wrapper" class="m-auto border-2s-e4e5ea br-5 p-30">
        
        <div class="d-flex justify-content-between">
            <div>
                <h3 class="pb-7 shop-name"><?php echo escape_output($this->session->userdata('business_name')); ?></h3>
                <p class="pb-7 common-heading"><?php echo escape_output($outlet_info->outlet_name); ?></p>
                <p class="pb-7 f-w-500 color-71"><?php echo escape_output($outlet_info->address); ?></p>
                <?php if($outlet_info->email != ''){ ?>
                <p class="pb-7 f-w-500 color-71"><?php echo lang('name');?>: <?php echo escape_output($outlet_info->email); ?></p>
                <?php } ?>
                <p class="pb-7 f-w-500 color-71"><?php echo lang('phone');?>: <?php echo escape_output($outlet_info->phone); ?></p>
            </div>
            <div class="d-flex align-items-center">
                <div class="m-auto">
                    <?php
                        $invoice_logo = $this->session->userdata('invoice_logo');
                        if($invoice_logo):
                    ?>
                        <img src="<?=base_url()?>uploads/site_settings/<?=escape_output($invoice_logo)?>">
                    <?php
                        endif;
                    ?>
                </div>
            </div>
        </div>

        <div class="text-center py-10">
            <h2 class="invoice-heading"><?php echo lang('Expense_Invoice');?></h2>
        </div>

        <div class="d-flex justify-content-between gap-5">
            <div>
                <h3 class="pb-7 common-heading"><?php echo lang('company_info');?></h3>
                <?php if($company_info->business_name != ''){ ?>
                <p class="pb-7 f-w-500 color-71"><span class="f-w-600"><?php echo lang('name');?>:</span> <?php echo escape_output($company_info->business_name); ?></p>
                <?php } ?>
                <?php if($company_info->phone != ''){ ?>
                <p class="pb-7 f-w-500 color-71"><span class="f-w-600"><?php echo lang('phone');?>:</span> <?php echo escape_output($company_info->phone); ?></p>
                <?php } ?>
                <?php if($company_info->email != ''){ ?>
                <p class="pb-7 f-w-500 color-71"><span class="f-w-600"><?php echo lang('email');?>:</span> <?php echo escape_output($company_info->email); ?></p>
                <?php } ?>
                <?php if($company_info->website != ''){ ?>
                <p class="pb-7 f-w-500 color-71"><span class="f-w-600"><?php echo lang('website');?>:</span> <?php echo escape_output($company_info->website); ?></p>
                <?php } ?>
            </div>
            <div>
                <?php $employee = getDataById($expense->employee_id, 'tbl_users'); ?>
                <h3 class="pb-7 common-heading"><?php echo lang('employee');?></h3>
                <?php if($employee->full_name != ''){ ?>
                <p class="pb-7 f-w-500 color-71"><span class="f-w-600"><?php echo lang('name');?>:</span> <?php echo escape_output($employee->full_name); ?></p>
                <?php } ?>
                <?php if($employee->phone != ''){ ?>
                <p class="pb-7 f-w-500 color-71"><span class="f-w-600"><?php echo lang('phone');?>:</span> <?php echo escape_output($employee->phone); ?></p>
                <?php } ?>
            </div>
        </div>

        <div>
            <table class="table w-100 mt-20">
                <thead class="br-3 bg-00c53">
                    <tr>
                        <th class="w-5 text-center"><?php echo lang('sn');?></th>
                        <th class="w-30 text-start"><?php echo lang('reference_no');?></th>
                        <th class="w-15 text-center"><?php echo lang('date');?></th>
                        <th class="w-15 text-center"><?php echo lang('category');?></th>
                        <th class="w-15 text-center"><?php echo lang('amount');?></th>
                        <th class="w-15 text-center"><?php echo lang('payment_method');?></th>
                    </tr>
                </thead>
                <tbody>
                    <tr>
                        <td class="text-center">
                            <span>1</span>
                        </td>
                        <td class="text-start">
                            <span><?php echo ($expense->reference_no) ?></span>
                        </td>
                        <td class="text-start">
                            <span><?php echo dateFormat($expense->date) ?></span>
                        </td>
                        <td class="text-right"><?php echo getName('tbl_expense_items', $expense->category_id) ?></td>
                        <td class="text-center"><?php echo getAmtCustom($expense->amount) ?></td>
                        <td class="text-right"><?php echo getName('tbl_payment_methods', $expense->payment_method_id) ?></td>
                    </tr>
                </tbody>
            </table>
        </div>

        <div class="d-grid g-template-c-50-40 grid-gap-10 pt-20">
            <div>
                <div class="pt-10">
                    <?php if($expense->note){ ?>
                    <h4 class="d-block pb-10"><?php echo lang('note');?></h4>
                    <div class="w-100 bg-240 m-h-120px-m-h-220px p-15 b-1s-240">
                        <p>
                            <?php echo escape_output($expense->note) ; ?>
                        </p>
                    </div>
                    <?php } ?>
                </div>
            </div>
        </div>

        <div class="d-flex justify-content-end mt-50">
            <div>
                <p class="color-71 d-inline b-t-1p-e4e5ea pt-10"><?php echo lang('authorized_signature');?></p>
            </div>
        </div>
        <div class="d-flex justify-content-center pt-30">
            <button onclick="window.print();" type="button" class="print-btn"><?php echo lang('print');?></button>
        </div>
    </div>
    <script src="<?php echo base_url(); ?>assets/bower_components/jquery/dist/jquery.min.js"></script>
    <script src="<?php echo base_url(); ?>frequent_changing/js/onload_print.js"></script>
</body>
</html>